/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.parsers;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class CoordinateNode
implements ToXContentObject {
    public final Coordinate coordinate;
    public final List<CoordinateNode> children;

    CoordinateNode(Coordinate coordinate) {
        this.coordinate = coordinate;
        this.children = null;
    }

    CoordinateNode(List<CoordinateNode> children) {
        this.children = children;
        this.coordinate = null;
    }

    public boolean isEmpty() {
        return this.coordinate == null && (this.children == null || this.children.isEmpty());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.children == null) {
            builder.startArray().value(this.coordinate.x).value(this.coordinate.y).endArray();
        } else {
            builder.startArray();
            for (CoordinateNode child : this.children) {
                child.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder;
    }
}

